#include <stdio.h>
#include <stdint.h>

#define print_list(B) for (int i=0; i<2*N; i++) printf("%d ",B[i]); putchar(0xa)

int get_sreca(const char *list, int N){
    int sreca=0;

    for (int i=1; i<2*N; i++){
        if (list[i] == list[i-1]) sreca++;
    }

    return sreca;
}

// NOTE: parametar A nije prava ulazna matrica, vec linearna verzija nje
int max_sreca_from_list(const int *A, int N){
    char B[2*N]; // napravi kopiju A koja umesto vrednosti sadrzi 0 ili 1, zavisi da li je paran
    for (int i=0; i<2*N; i++) B[i] = A[i]&1;
    for (int i=0; i<N; i++) {
        int p = 2*i;
        if (B[p]==B[p+1]) continue;
        
        if (i+1 < N){
            if (i) if (B[p] == B[p-1]) continue;
            if (B[p] == B[p+2] && B[p+1] != B[p+2]){
                char t = B[p];
                B[p] = B[p+1];
                B[p+1] = t;
            }
        } else if (B[p+1] == B[p-1]) {
            char t = B[p];
            B[p] = B[p+1];
            B[p+1] = t;
        }
    }
    return get_sreca(B, N);
}

int test(){
    int N;
    scanf("%d", &N);
    int A[2][N]; // glavna matrica A po testu

    // ulaz A
    for (int i=0; i<N; i++) { int x; scanf("%d",&x); A[0][i] = x; }
    for (int i=0; i<N; i++) { int x; scanf("%d",&x); A[1][i] = x; }
    
    int A_linear[2*N]; // linearni prikaz matrice A
    for (int j=0; j<N; j++){
        A_linear[2*j] = A[0][j];
        A_linear[2*j+1] = A[1][j];
    }
    int sreca = max_sreca_from_list(A_linear, N);
    return sreca;
}


int main(){
    uint16_t T; scanf("%hu", &T);
    int srece[T];
    for (uint16_t i=0; i<T; i++){
        srece[i] = test();
    }
    for (uint16_t i=0; i<T; i++){
        printf("%d\n", srece[i]);
    }
    return 0;
}